'use strict';

var Sequelize, DataTypes, Promise = require('bluebird'), _ = require('lodash'), moment = require('moment');

Sequelize = DataTypes = require('./index.js');
const dialect = 'mysql';

let sequelize;
const options = {
  define: {
    timestamps: false
  },
  pool: {
    max: 10
  },
  benchmark: true,
  logging: console.log
};

switch (dialect)  {
  case 'postgres':
    sequelize = new Sequelize('sequelize_test', 'sequelize_test', 'sequelize_test', Object.assign({
      dialect: 'postgres',
      port: 8998
    }, options));
    break;

  case 'mysql':
    sequelize = new Sequelize('sequelize_test', 'sequelize_test', 'sequelize_test', Object.assign({
      dialect: 'mysql',
      port: 8999
    }, options));
    break;

  case 'mssql':
    sequelize = new Sequelize('model', 'sa', 'yourStrong(!)Password', Object.assign({
      dialect: 'mssql',
      port: 8997
    }, options));
    break;
}

const Transaction = sequelize.define('transaction', {
  ttype: {
    type: Sequelize.ENUM('purchase', 'withdrawal', 'deposit', 'trade', 'transfer'),
    allowNull: false
  }
});

return sequelize.sync({
  force: true,
  logging: console.log
})
  .then(() => {
    return Transaction.create({
      ttype: 'foo'
    })
  })
  .finally(() => sequelize.close());
