#!/usr/bin/env python
#
# Public Domain 2014-2015 MongoDB, Inc.
# Public Domain 2008-2014 WiredTiger, Inc.
#
# This is free and unencumbered software released into the public domain.
#
# Anyone is free to copy, modify, publish, use, compile, sell, or
# distribute this software, either in source code form or as a compiled
# binary, for any purpose, commercial or non-commercial, and by any
# means.
#
# In jurisdictions that recognize copyright laws, the author or authors
# of this software dedicate any and all copyright interest in the
# software to the public domain. We make this dedication for the benefit
# of the public at large and to the detriment of our heirs and
# successors. We intend this dedication to be an overt act of
# relinquishment in perpetuity of all present and future rights to this
# software under copyright law.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
#
# test_bug003.py
#       Regression tests.

import wiredtiger, wttest
from wtscenario import multiply_scenarios, number_scenarios

# Regression tests.
class test_bug003(wttest.WiredTigerTestCase):
    types = [
        ('file', dict(uri='file:data')),
        ('table', dict(uri='table:data')),
    ]
    ckpt = [
        ('no', dict(name=0)),
        ('yes', dict(name=1)),
    ]

    scenarios = number_scenarios(multiply_scenarios('.', types, ckpt))

    # Confirm bulk-load isn't stopped by checkpoints.
    def test_bug003(self):
        self.session.create(self.uri, "key_format=S,value_format=S")
        if self.name == 1:
            self.session.checkpoint("name=ckpt")
        else:
            self.session.checkpoint()
        cursor = self.session.open_cursor(self.uri, None, "bulk")


if __name__ == '__main__':
    wttest.run()
