Benchmark = require 'benchmark'
Trie = require 'unicode-trie'
classes = require './src/classes'

global.trie = new Trie require './src/class_trie'
  
characterClasses = classes.characterClasses
global.getCharClass = (char) ->  
  low = 0
  high = characterClasses.length

  while low < high
    mid = (low + high) >>> 1
    range = characterClasses[mid]

    if char > range.end
      low = mid + 1

    else if char < range.start
      high = mid

    else
      return range.class

  return classes.XX
  
suite = new Benchmark.Suite
suite.add 'binary search', ->
  for i in [0...0x10fffd] by 1
    getCharClass i
    
  return
  
suite.add 'trie', ->
  for i in [0...0x10fffd] by 1
    trie.get i
    
  return
  
suite.on 'cycle', (e) ->
  console.log String e.target

suite.on 'error', (e) ->
  console.log e.target.error.stack
  process.exit()
  
suite.on 'complete', ->
  benches = @filter 'successful'
  fastest = @filter 'fastest'
  
  for bench in benches
    percent = Math.round((1 - bench.hz / fastest[0].hz) * 100)
    if bench is fastest[0]
      console.log bench.name, 'is the fastest'
    else
      console.log "#{bench.name} is #{percent}% slower"
  
suite.run()
